/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BaseBarkBlock
extends BaseRotatedPillarBlock {
    protected BaseBarkBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected Optional<String> createBlockPattern(ResourceLocation blockId) {
        blockId = BuiltInRegistries.f_256975_.m_7981_((Object)this);
        return PatternsHelper.createJson(BasePatterns.BLOCK_BASE, this.replacePath(blockId));
    }

    private ResourceLocation replacePath(ResourceLocation blockId) {
        String newPath = blockId.m_135815_().replace("_bark", "_log_side");
        return new ResourceLocation(blockId.m_135827_(), newPath);
    }

    public static class Wood
    extends BaseBarkBlock
    implements BehaviourWood,
    TagProvider {
        private final boolean flammable;

        public Wood(BlockBehaviour.Properties settings, boolean flammable) {
            super(flammable ? settings.m_278183_() : settings);
            this.flammable = flammable;
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            blockTags.add((TagKey<Block>)BlockTags.f_13106_);
            itemTags.add((TagKey<Item>)ItemTags.f_13182_);
            if (this.flammable) {
                blockTags.add((TagKey<Block>)BlockTags.f_13105_);
                itemTags.add((TagKey<Item>)ItemTags.f_13181_);
            }
        }
    }
}

